#ifndef _HATTELANDAPI_COMMANDS_H_
#define _HATTELANDAPI_COMMANDS_H_

#define HW_PLATFORM_AIPC 0x00
#define HW_PLATFORM_QM57 0x01
#define HW_PLATFORM_IPC  0x02

#define HW_DEVICE_PCA9555					0x40

#define HW_DEVICE_WATCHDOG_PCB				0x90
#define HW_DEVICE_TOUCH_KEY_CONTROL_BOARD	0x92
#define HW_DEVICE_BIOS_ROM					0x0C		// Virtual Address as SMBus is not used

// PCA 9555

#define QM57_CFG0				0x06 + (HW_DEVICE_PCA9555 << 8)
#define QM57_BUZZER_EN			0x02 + (HW_DEVICE_PCA9555 << 8) 
#define QM57_BUZZER_DIS			0x02 + (HW_DEVICE_PCA9555 << 8) + 0x010000
#define QM57_FULL_DUPLEX		0x02 + (HW_DEVICE_PCA9555 << 8) + 0x020000
#define QM57_HALF_DUPLEX		0x02 + (HW_DEVICE_PCA9555 << 8) + 0x030000

//GDC controls
#define FIRMWARE_VERSION				0x06 + (HW_DEVICE_TOUCH_KEY_CONTROL_BOARD << 8)
#define BACK_LIGHT_ADJUSTMENT			0x09 + (HW_DEVICE_TOUCH_KEY_CONTROL_BOARD << 8)
#define BRU								0x03 + (HW_DEVICE_TOUCH_KEY_CONTROL_BOARD << 8)
#define PAD_LED_HBYTE					0x00 + (HW_DEVICE_TOUCH_KEY_CONTROL_BOARD << 8)
#define PAD_LED_LBYTE					0x01 + (HW_DEVICE_TOUCH_KEY_CONTROL_BOARD << 8) + 0x090000
#define PAD_LED_DIMMING					0x02 + (HW_DEVICE_TOUCH_KEY_CONTROL_BOARD << 8)
#define AMBIENT_LIGHT_SENSOR			0x04 + (HW_DEVICE_TOUCH_KEY_CONTROL_BOARD << 8)
#define PAD_LED_ECDIS_OFF				0x01 + (HW_DEVICE_TOUCH_KEY_CONTROL_BOARD << 8) + 0x010000
#define PAD_LED_ECDIS_ON				0x01 + (HW_DEVICE_TOUCH_KEY_CONTROL_BOARD << 8) + 0x020000
#define PAD_LED_HDD_OFF					0x01 + (HW_DEVICE_TOUCH_KEY_CONTROL_BOARD << 8) + 0x030000
#define PAD_LED_HDD_ON_Green			0x01 + (HW_DEVICE_TOUCH_KEY_CONTROL_BOARD << 8) + 0x040000
#define PAD_LED_HDD_ON_Red				0x01 + (HW_DEVICE_TOUCH_KEY_CONTROL_BOARD << 8) + 0x050000
#define PAD_LED_ON						0x07 + (HW_DEVICE_TOUCH_KEY_CONTROL_BOARD << 8) + 0x060000
#define PAD_LED_OFF						0x07 + (HW_DEVICE_TOUCH_KEY_CONTROL_BOARD << 8) + 0x070000
#define PAD_LED_RECALL					0x07 + (HW_DEVICE_TOUCH_KEY_CONTROL_BOARD << 8) + 0x080000
#define PAD_BACKLIGHT_STD_VALUE			0x08 + (HW_DEVICE_TOUCH_KEY_CONTROL_BOARD << 8)
#define PAD_SET_CAL_2_BRU				0x08 + (HW_DEVICE_TOUCH_KEY_CONTROL_BOARD << 8) + 0x010000
																					   
#define TYPE_NO_W						0x01 + (HW_DEVICE_BIOS_ROM << 8)
#define TYPE_NO_R						0x02 + (HW_DEVICE_BIOS_ROM << 8)
#define SERIAL_NO_W						0x03 + (HW_DEVICE_BIOS_ROM << 8)
#define SERIAL_NO_R						0x04 + (HW_DEVICE_BIOS_ROM << 8)
#define HW_ID_W							0x05 + (HW_DEVICE_BIOS_ROM << 8)
#define HW_ID_R							0x06 + (HW_DEVICE_BIOS_ROM << 8)
#define SIZE_OF_FILE					0x07 + (HW_DEVICE_BIOS_ROM << 8)
#define DOWNLOAD_FILE					0x08 + (HW_DEVICE_BIOS_ROM << 8)
#define STORE_FILE						0x09 + (HW_DEVICE_BIOS_ROM << 8)

#endif //_HATTELANDAPI_COMMANDS_H_